/*
 * Decompiled with CFR 0.152.
 */
package glodblock.com.github.network;

import glodblock.com.github.gui.ScannerGUI;
import glodblock.com.github.gui.ScannerGUITexture;
import glodblock.com.github.handlers.HandlerIEVein;
import glodblock.com.github.handlers.HandlerOilVein;
import glodblock.com.github.handlers.HandlerOreData;
import glodblock.com.github.network.GuiOpenPacket;
import glodblock.com.github.orevisualdetector.Main;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ScannerPacket
implements IMessage {
    public int chunkX;
    public int chunkZ;
    public int posX;
    public int posZ;
    public int size;
    public int ptype;
    public HashMap<Byte, Short>[][] map;
    public HashMap<String, Integer> ores;
    public HashMap<Short, String> metaMap;
    public int level = -1;

    public ScannerPacket() {
    }

    public ScannerPacket(int chunkX, int chunkZ, int posX, int posZ, int size, int ptype) {
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.posX = posX;
        this.posZ = posZ;
        this.size = size;
        this.ptype = ptype;
        this.map = new HashMap[(size * 2 + 1) * 16][(size * 2 + 1) * 16];
        this.ores = new HashMap();
        this.metaMap = new HashMap();
    }

    public static void addOre(ScannerPacket packet, short id) {
        try {
            if (packet.ptype == 0) {
                String unlocalizedName = HandlerOreData.mIDToNameMap.get(id);
                short[] rgba = new short[]{0, 0, 0};
                if (HandlerOreData.mOreDictMap.containsKey(unlocalizedName)) {
                    rgba = HandlerOreData.mOreDictMap.get(unlocalizedName);
                } else if (HandlerOreData.mUnlocalizedMap.containsKey(unlocalizedName)) {
                    rgba = HandlerOreData.mUnlocalizedMap.get(unlocalizedName);
                }
                packet.ores.put(unlocalizedName, ((rgba[0] & 0xFF) << 16) + ((rgba[1] & 0xFF) << 8) + (rgba[2] & 0xFF));
                packet.metaMap.put(id, unlocalizedName);
            } else if (packet.ptype == 1) {
                if (HandlerIEVein.IDToVeinMap.containsKey(id)) {
                    String veinName = HandlerIEVein.IDToVeinMap.get(id);
                    short[] rgba = HandlerIEVein.veinMap.get(veinName);
                    packet.ores.put(veinName, ((rgba[0] & 0xFF) << 16) + ((rgba[1] & 0xFF) << 8) + (rgba[2] & 0xFF));
                    packet.metaMap.put(id, veinName);
                }
            } else if (packet.ptype == 2 && HandlerOilVein.getFluid(id) != null) {
                Fluid fluid = HandlerOilVein.getFluid(id);
                short[] rgba = HandlerOilVein.fluidMap.get(fluid.getName());
                packet.ores.put(fluid.getName(), ((rgba[0] & 0xFF) << 16) + ((rgba[1] & 0xFF) << 8) + (rgba[2] & 0xFF));
                packet.metaMap.put(id, fluid.getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addBlock(int x, int y, int z, short id) {
        int aX = x - (this.chunkX - this.size) * 16;
        int aZ = z - (this.chunkZ - this.size) * 16;
        if (this.map[aX][aZ] == null) {
            this.map[aX][aZ] = new HashMap();
        }
        this.map[aX][aZ].put((byte)y, id);
    }

    public int getSize() {
        return (this.size * 2 + 1) * 16;
    }

    public void fromBytes(ByteBuf buf) {
        this.chunkX = buf.readInt();
        this.chunkZ = buf.readInt();
        this.posX = buf.readInt();
        this.posZ = buf.readInt();
        this.size = buf.readInt();
        this.ptype = buf.readInt();
        this.map = new HashMap[(this.size * 2 + 1) * 16][(this.size * 2 + 1) * 16];
        this.ores = new HashMap();
        this.metaMap = new HashMap();
        this.level = buf.readInt();
        int aSize = (this.size * 2 + 1) * 16;
        for (int i = 0; i < aSize; ++i) {
            for (int j = 0; j < aSize; ++j) {
                int kSize = buf.readByte();
                if (kSize == 0) continue;
                this.map[i][j] = new HashMap();
                for (int k = 0; k < kSize; ++k) {
                    byte y = buf.readByte();
                    short meta = buf.readShort();
                    this.map[i][j].put(y, meta);
                }
            }
        }
        int size = buf.readShort();
        for (int i = 0; i < size; ++i) {
            short id = buf.readShort();
            int color = buf.readInt();
            if (this.ptype == 0) {
                this.ores.put(HandlerOreData.mIDToNameMap.get(id), color);
                this.metaMap.put(id, HandlerOreData.mIDToNameMap.get(id));
                continue;
            }
            if (this.ptype == 1) {
                this.ores.put(HandlerIEVein.IDToVeinMap.get(id), color);
                this.metaMap.put(id, HandlerIEVein.IDToVeinMap.get(id));
                continue;
            }
            if (this.ptype != 2) continue;
            this.ores.put(HandlerOilVein.getFluid(id).getName(), color);
            this.metaMap.put(id, HandlerOilVein.getFluid(id).getName());
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.chunkX);
        buf.writeInt(this.chunkZ);
        buf.writeInt(this.posX);
        buf.writeInt(this.posZ);
        buf.writeInt(this.size);
        buf.writeInt(this.ptype);
        buf.writeInt(this.level);
        int aSize = (this.size * 2 + 1) * 16;
        for (int i = 0; i < aSize; ++i) {
            for (int j = 0; j < aSize; ++j) {
                if (this.map[i][j] == null) {
                    buf.writeByte(0);
                    continue;
                }
                buf.writeByte(this.map[i][j].keySet().size());
                for (byte key : this.map[i][j].keySet()) {
                    buf.writeByte((int)key);
                    buf.writeShort((int)this.map[i][j].get(key).shortValue());
                }
            }
        }
        buf.writeShort(this.ores.size());
        for (Map.Entry<String, Integer> p : this.ores.entrySet()) {
            String name = p.getKey();
            int color = p.getValue();
            if (this.ptype == 0) {
                buf.writeShort((int)HandlerOreData.mNameToIDMap.get(name).shortValue());
                buf.writeInt(color);
                continue;
            }
            if (this.ptype == 1) {
                buf.writeShort((int)HandlerIEVein.veinToIDMap.get(name).shortValue());
                buf.writeInt(color);
                continue;
            }
            if (this.ptype != 2) continue;
            buf.writeShort(HandlerOilVein.getFluidID(name));
            buf.writeInt(color);
        }
    }

    public static class Handler
    implements IMessageHandler<ScannerPacket, IMessage> {
        @Nullable
        public IMessage onMessage(ScannerPacket message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                ScannerGUI.newMap(new ScannerGUITexture(message));
                Main.proxy.netHandler.sendToServer((IMessage)new GuiOpenPacket());
            });
            return null;
        }
    }
}

